
#|________________________________________________________________________
 |
 |Multivariate Regression plugin loading function
 |________________________________________________________________________
 |#

(setf *mmr-plugin-path* (strcat *plugin-path* "mmrplug" *separator*))
(let ((menu-item-title "Multivariate Regression")
      (tool-name "MulReg")
      (model-prefix "Mrg")
      (ok-data-types '("bivariate" "multivariate" "crosstabs" "general"))
      (ok-variable-types '(numeric)))

  (send *vista* :install-plugin tool-name menu-item-title ok-data-types)

  (defun multivariate-regression (&rest args )
"ViSta plugin function to perform Multivariate Regression analysis.  
With no arguments the current data are analyzed, with the first active numeric variable as the response, and the remaining active numeric variables as the predictors. Keyword arguments are
:RESPONSES followed by a list of the response variables 
      (if there is more than one response variable then several separate
       multiple regressions are performed, each with the same predictors);
:PREDICTORS followed by a list of the predictor variables;
:WEIGHT followed by a variable name (nil by default);
:INTERCEPT followed by t if an intercept is to be computed (default) or nil;
:REDUNDANCY followed by a value specifying the number of redundancy variables  to be computed or nil if they are not to be computed (default);
:DATA   followed by the data-object to be analyzed (default: current-data);
:TITLE  followed by a character string (default: Multivariate Regression);
:DIALOG followed by t (to display parameters dialog box) or nil (default)."    
    (format t "; CopyRt: MULREG Copyright (c) 1992-2002, by Forrest W. Young~%> ")
    (load (strcat *mmr-plugin-path* "mmrmob1"))
    (apply #'multivariate-regression args))
  )


